<!DOCTYPE html>
<html>
<head>
    <title>Laporan Absensi</title>
    
    <style>
        body { font-family: sans-serif; font-size: 10px; margin: 0; padding: 0; }
        .container { padding: 20px; }
        
        /* === HEADER DAN BRANDING === */
        .header { 
            text-align: center; 
            margin-bottom: 20px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 10px;
        }
        .header-content {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 10px;
        }
        .header img {
            width: 40px; /* Ukuran Logo */
            height: 40px;
            object-fit: cover;
            margin-right: 15px;
        }
        .header h2 { margin: 0; font-size: 16px; color: #333; }
        .header h4 { margin: 0; font-size: 11px; color: #555; }

        /* === INFO LAPORAN === */
        .info { margin-bottom: 15px; }
        .info p { 
            margin: 2px 0; 
            font-size: 10px; 
            text-align: center;
        }

        /* === TABEL === */
        .table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        .table th, .table td { 
            border: 1px solid #ddd; 
            padding: 5px 8px; 
            text-align: left; 
        }
        .table th { 
            background-color: #0d6efd; 
            color: white; /* Header putih */
            font-size: 10px; 
            text-transform: uppercase;
        }
        .table td { 
            font-size: 9px; 
        }

        /* === STATUS COLORS === */
        .status-hadir { color: #198754; font-weight: bold; } /* Hijau */
        .status-terlambat { color: #ffc107; font-weight: bold; } /* Kuning */
        .status-absen, .status-izin, .status-sakit { color: #dc3545; font-weight: bold; } /* Merah */
    </style>
</head>
<body>
    <div class="container">
        
        <?php
            // Asumsi $settings tersedia (dikiriman dari Controller)
            $settings = $settings ?? ['school_name' => 'E-ABSENSI SEKOLAH', 'school_logo' => 'default/logo.png']; 
            $logoPath = public_path('storage/' . ($settings['school_logo'] ?? 'default/logo.png'));
        ?>
        
        <div class="header">
            <div class="header-content">
                
                <?php if(file_exists($logoPath)): ?>
                    <img src="<?php echo e($logoPath); ?>" alt="Logo Sekolah">
                <?php endif; ?>
                <div>
                    <h2>LAPORAN ABSENSI SISWA</h2>
                    <h4><?php echo e($settings['school_name'] ?? 'NAMA SEKOLAH BELUM DISET'); ?></h4>
                </div>
            </div>
            
            <div class="info">
                <p>Periode: <?php echo e($startDate->format('d F Y')); ?> s/d <?php echo e($endDate->format('d F Y')); ?></p>
                <p>Kelas: <?php if($class): ?> <?php echo e($class->name); ?> <?php else: ?> Semua Kelas <?php endif; ?></p>
            </div>
        </div>

        <table class="table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Tanggal</th>
                    <th>Waktu</th>
                    <th>NISN</th>
                    <th>Nama Siswa</th>
                    <th>Kelas</th>
                    <th>Status</th>
                    <th>Terlambat (Menit)</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $absences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $absence): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $status = $absence->status ?? 'N/A';
                    // Menghapus spasi dan mengubah ke lowercase untuk kelas CSS
                    $statusClass = 'status-' . strtolower(str_replace([' ', '-'], '', $status)); 
                ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($absence->attendance_time->format('d/m/Y')); ?></td>
                    <td><?php echo e($absence->attendance_time->format('H:i:s')); ?></td>
                    <td><?php echo e($absence->student->nisn ?? 'N/A'); ?></td>
                    <td><?php echo e($absence->student->name ?? 'N/A'); ?></td>
                    <td><?php echo e($absence->student->class->name ?? 'N/A'); ?></td>
                    <td class="<?php echo e($statusClass); ?>"><?php echo e($status); ?></td>
                    <td><?php echo e(($status == 'Terlambat' && $absence->late_duration) ? $absence->late_duration . ' min' : '-'); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" style="text-align: center;">Tidak ada data absensi dalam periode ini.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
    </div>
</body>
</html><?php /**PATH D:\laragon\www\e-absensi-siswa\resources\views/admin/reports/pdf_template.blade.php ENDPATH**/ ?>